﻿using System;
using System.Collections.Generic;
using System.Text;
using System.ComponentModel;

namespace IndianHealthService.BMXNet.WinForm
{
    /// <summary>
    /// The LoginProcess provides the AttemptingLoginEvent to allow changes in workflow with
    /// this Cancelable event args class
    /// </summary>
    public class AttemptingLoginEventArgs : CancelEventArgs
    {
        /// <summary>
        /// The LoginProcess can be modified (e.g. ConnectionSpec) after the user has OK'd the dialog
        /// but before the login attempt is made. 
        /// </summary>
        public LoginProcess Process { get; set; }

        /// <summary>
        /// The receiver of the event can perform the login differently or not allow
        /// the login.  If Handled is set the True the LoginProcess assumes the login was attempted.
        /// </summary>
        public bool Handled { get; set; }

        /// <summary>
        /// Set HandledSucccessfully is the Handled logging was successful.
        /// </summary>
        public bool HandledSucccessfully { get; set; }
    }
}
